# File : "mfMacros.tcl"
#                        Created : 2001-02-06 22:07:36
#              Last modification : 2001-02-13 23:59:13
# Author : Bernard Desgraupes
# e-mail : <berdesg@easynet.fr>
# www : <http://perso.easynet.fr/~berdesg/>
# Description : this file is part of the Metafont Mode package for 
# Alpha. See comments at the beginning of 'mfMode.tcl'.
# 

namespace eval Mf {}


# --------------------------------------
# Creating a new font template
# --------------------------------------

proc Mf::newtemplateProc {} {
    global MfmodeVars 
    new -n "newfont.mf"
    # How many chars in the font
    beep
    catch {prompt "How many chars in the new font ?" 128} nbchr
    if {$nbchr == "cancel"} {
	return
    } elseif {![is::PositiveInteger $nbchr]} {
	beep
	message "invalid input: please enter a positive integer"
	return
    }
    goto [minPos]
    # Preambule instructions
    set t "\% This file : \n"
    append t "\% Created : [ISOTime::ISODateAndTimeRelaxed]\n"	
    append t "\% Modified : [ISOTime::ISODateAndTimeRelaxed]\n"	
    append t "\% Comments : \n% \n% \n% \n\n"	
    append t "font_size  pt\#;    \% the \"design size\" of this font\n\n"
    append t "mode_setup;"
    append t "\n\n\%\%\%\% Parameters \%\%\%\%\n\n"
    append t "\n\n\%\%\%\% Pixellisation \%\%\%\%\n\n"
    append t "define_pixels();\n"
    append t "define_whole_pixels();\n"
    append t "define_whole_vertical_pixels();\n"
    append t "define_blacker_pixels();\n"
    append t "define_good_x_pixels();\n"
    append t "define_good_y_pixels();\n"
    append t "define_corrected_pixels();\n"
    append t "define_horizontal_corrected_pixels();\n"
    append t "\n\n\%\%\%\% Macros and definitions \%\%\%\%\n\n"
    append t "\n\n\%\%\%\% Drawing instructions for the characters \%\%\%\%\n\n"
    insertText $t
    set i 0
    for {set i 0} {$i < $nbchr} {incr i} {
	insertText "$MfmodeVars(userBeginchar)([set i],,,);\"\";\n\n\n\n$MfmodeVars(userEndchar);\n\n"
    }
    # Postambule instructions
    set t "\n\n\%\%\%\% Ligtables and kerning \%\%\%\%\n\n"
    append t "ligtable \"\": \"\" kern  \#;\n"
    append t "\n\n\%\%\%\% General Font Parameters \%\%\%\%\n\n"	
    append t "font_slant:= ;\t\t\t\% slant per point\n"
    append t "font_normal_space:= ;\t\t\% interword spacing\n"
    append t "font_normal_stretch:= ;\t\% stretchability of interword spacing\n"
    append t "font_normal_shrink:=;\t\t\% shrinkability of interword spacing\n"
    append t "font_x_height:= ;\t\t\% TeX's ex unit\n"
    append t "font_quad:= ;\t\t\t\% TeX's em unit\n"
    append t "font_extra_space:= ;\t\t\% additional spacing between sentences\n"
    append t "\nfont_coding_scheme:= \"\";\t\% coding scheme (optional)\n"
    append t "font_identifier:= \"\";\t\t\% family (optional)\n"
    append t "\n\nbye"
    insertText $t
    goto [minPos]
}


# -----------------------------------------
# Submenus to insert Metafont commands
# -----------------------------------------


proc Mf::variablesProc {menu item} {
    set item [string trimleft $item]
    insertObject "$item ;\n"
}

proc Mf::booleanProc {menu item} {
    set item [string trimleft $item]
    insertObject "$item "
}

proc Mf::functionsProc {menu item} {
    switch $item {	
	" angle" {insertObject "angle ;\n"}
	" ceilling" {insertObject "ceilling ;\n"}
	" floor" {insertObject "floor()"}
	" cosd" {insertObject "cosd()"}
	" sind" {insertObject "sind()"}
	" mexp" {insertObject "mexp()"}
	" mlog" {insertObject "mlog()"}
	" sqrt" {insertObject "sqrt()"}
	" dotprod" {insertObject "dotprod  = ;\n"}
	" eps" {insertObject "eps "}
	" epsilon" {insertObject "epsilon "}
	" infinity" {insertObject "infinity "}
	" round" {insertObject "round()"}
	" hround" {insertObject "hround()"}
	" vround" {insertObject "vround()"}
	" solve" {insertObject "solve (,);\n"}
	" tolerance" {insertObject "tolerance:= ;\n"}
	" normaldeviate" {insertObject "normaldeviate()"}
	" randomseed" {insertObject "randomseed:= ;\n"}
	" uniformdeviate" {insertObject "uniformdeviate()"}
	" whatever" {insertObject "whatever "}
    }
}

proc Mf::positioningProc {menu item} {
    switch $item {	
	" clearxy" {insertObject "clearxy ;\n"}
	" direction" {insertObject "direction  of "}
	" directionpoint" {insertObject "directionpoint  of "}
	" directiontime" {insertObject "directiontime  of ;\n"}
	" penoffset" {insertObject "penoffset  of "}
	" pointof" {insertObject "point  of "}
	" precontrolof" {insertObject "precontrol  of "}
	" postcontrolof" {insertObject "postcontrol  of "}
	" intersectionpoint" {insertObject "  intersectionpoint "}
	" intersectiontimes" {insertObject " intersectiontimes "}
	" good.bot" {insertObject "good.bot "}
	" good.lft" {insertObject "good.lft "}
	" good.rt" {insertObject "good.rt "}
	" good.top" {insertObject "good.top "}
	" good.x" {insertObject "good.x "}
	" good.y" {insertObject "good.y "}
	" xpart" {insertObject "xpart()"}
	" xxpart" {insertObject "xxpart()"}
	" xypart" {insertObject "xypart()"}
	" ypart" {insertObject "ypart()"}
	" yxpart" {insertObject "yxpar()"}
	" yypart" {insertObject "yypart()"}
    }
}

proc Mf::pathsProc {menu item} {
    switch $item {	
	" penstroke" {insertObject "penstroke ;\n"}
	" buildpenstroke" {Mf::penstrokeProc}
	" flex" {Mf::mkflexProc}
	" fullcircle" {insertObject "fullcircle "}
	" halfcircle" {insertObject "halfcircle "}
	" quartercircle" {insertObject "quartercircle "}
	" superellipse" {insertObject "superellipse(,,,,);\n"}
	" unitsquare" {insertObject "unitsquare "}
	" makepath" {insertObject "makepath ;\n"}
	" interpath" {insertObject "interpath(,,);\n"}
	" subpath" {insertObject "subpath(,) of "}
	" tensepath" {insertObject "tensepath "}
	" counterclockwise" {insertObject "counterclockwise "}
	" reverse" {insertObject "reverse "}
	" turningnumber" {insertObject "turningnumber "}
    }
}

proc Mf::pensProc {menu item} {
    switch $item {	
	" clear_pen_memory" {insertObject "clear_pen_memory;"}
	" clearpen" {insertObject "clearpen;"}
	" currentpen" {insertObject "currentpen "}
	" makepen" {insertObject "makepen "}
	" nullpen" {insertObject "nullpen;"}
	" savepen" {insertObject ":=savepen;"}
	" pencircle" {insertObject "pencircle "}
	" pickuppencircle" {insertObject "pickup pencircle "}
	" pencirclescaled" {insertObject "pencircle  xscaled  yscaled ;\n"}
	" pickuppencirclescaled" {insertObject "pickup pencircle  xscaled  yscaled ;\n"}
	" pensquare" {insertObject "pensquare "}
	" pickuppensquare" {insertObject "pickup pensquare "}
	" pensquarescaled" {insertObject "pensquare  xscaled  yscaled ;\n"}
	" pickuppensquarescaled" {insertObject "pickup pensquare  xscaled  yscaled ;\n"}
	" penrazor" {insertObject "penrazor;"}
	" penspeck" {insertObject "penspeck;"}
	" penpos" {insertObject "penpos(,);\n"}
	" pen_bot" {insertObject "pen_bot"}
	" pen_lft" {insertObject "pen_lft"}
	" pen_rt" {insertObject "pen_rt"}
	" pen_top" {insertObject "pen_top"}
	" pickup" {insertObject "pickup "}
    }
}

proc Mf::picturesProc {menu item} {
    set item [string trimleft $item]
    switch $item {	
	"clearit" {insertObject "$item ;\n"}
	default {insertObject "$item "}
    }
}

proc Mf::stringsProc {menu item} {
    set item [string trimleft $item]
    switch $item {	
	"ditto" -
	"jobname" {insertObject "$item"}
	"readstring" {insertObject ":=readstring;"}
	"substring" {insertObject "substring(,) of "}
    }
}

proc Mf::transformationsProc {menu item} {
    set item [string trimleft $item]
    switch $item {	
	"reflectedabout" -
	"rotatedaround" {insertObject "${item}(,) "}
	default {insertObject "$item "}
    }
}

proc Mf::definitionsProc {menu item} {
    switch $item {	
	" defenddef" {insertObject "def =\n\nenddef;\n"}
	" suffix" {insertObject "(suffix )"}
	" expr" {insertObject "(expr )"}
	" text" {insertObject "(text )"}
	" primarydefenddef" {insertObject "primarydef =\n\nenddef;\n"}
	" secondarydefenddef" {insertObject "secondarydef =\n\nenddef;\n"}
	" tertiarydefenddef" {insertObject "tertiarydef =\n\nenddef;\n"}
	" vardefenddef" {insertObject "vardef =\n\nenddef;\n"}
	" begingroupendgroup" {insertObject "begingroup \n\nendgroup;\n"}
    }
}

proc Mf::conditionsProc {menu item} {
    switch $item {	
	" forendfor" {insertObject "for  :  endfor;\n"}
	" foreverendfor" {insertObject "forever  endfor;\n"}
	" forsuffixesendfor" {insertObject "forsuffixes  :  endfor;\n"}
	" iffi" {insertObject "if  :  fi\n"}
	" ifelseifelsefi" {insertObject "if  elseif  else  fi\n"}
	" downto" {insertObject "downto "}
	" upto" {insertObject "upto "}
	" stepuntil" {insertObject "step  until  : "}
	" exitif" {insertObject "exitif ;"}
	" exitunless" {insertObject "exitunless ;"}
    }
}

proc Mf::drawingProc {menu item} {
    switch $item {	
	" addtoalso" {insertObject "addto  also ;\n"}
	" addtocurrentpicture" {insertObject "addto currentpicture also currentpicture;\n"}
	" addtocontour" {insertObject "addto  contour  ;\n"}
	" addtocontourwithpen" {insertObject "addto  contour  withpen ;\n"}
	" addtocontourwithweight" {insertObject "addto  contour  withweight ;\n"}
	" addtodoublepath" {insertObject "addto  doublepath ;\n"}
	" addtodoublepathwithpen" {insertObject "addto  doublepath  withpen ;\n"}
	" addtodoublepathwithweight" {insertObject "addto  doublepath  withweight ;\n"}
	" culldropping" {insertObject "cull  dropping (,);\n"}
	" culldroppingwithweight" {insertObject "cull  dropping (,) withweight ;\n"}
	" cullkeeping" {insertObject "cull  keeping (,);\n"}
	" cullkeepingwithweight" {insertObject "cull  keeping (,) withweight ;\n"}
	" cullit" {insertObject "cullit ;\n"}
	" cutdraw" {insertObject "cutdraw "}
	" cutoff" {insertObject "cutoff(,);\n"}
	" draw" {insertObject "draw "}
	" drawdot" {insertObject "drawdot ;\n"}
	" erase" {insertObject "erase ;\n"}
	" fill" {insertObject "fill ;\n"}
	" filldraw" {insertObject "filldraw ;\n"}
	" undraw" {insertObject "undraw "}
	" undrawdot" {insertObject "undrawdot ;\n"}
	" unfill" {insertObject "unfill ;\n"}
	" unfilldraw" {insertObject "unfilldraw ;\n"}
    }
}

proc Mf::charactersProc {menu item} {
    global MfmodeVars 
    switch $item {	
	" begincharendchar" {insertObject "$MfmodeVars(userBeginchar)(\"\",,,);\"\";\n\n$MfmodeVars(userEndchar);\n"}
	" extra_beginchar" {insertObject "extra_beginchar:=\"  \";\n"}
	" extra_endchar" {insertObject "extra_endchar:=\"  \";\n"}
    }
}

proc Mf::unitsProc {menu item} {
    switch $item {	
	" blacker" {insertObject "blacker:=;\n"}
	" fillin" {insertObject "fillin:=;\n"}
	" o_correction" {insertObject "o_correction:= ;\n"}
	" fix_units" {insertObject "fix_units;\n"}
	" mode_setup" {insertObject "mode_setup;\n"}
	" pixels_per_inchs" {insertObject "pixels_per_inchs:=;\n"}
	" aspect_ratio" {insertObject "aspect_ratio:=;\n"}
    }
}

proc Mf::pixellisationProc {menu item} {
    set item [string trimleft $item]
    insertObject "${item}();\n"
}

proc Mf::fontInternalsProc {menu item} {
    switch $item {	
	" charlist" {insertObject "charlist :  :  :  : "}
	" extensible" {insertObject "extensible : , , , "}
	" font_coding_scheme" {insertObject "font_coding_scheme:= \"\";\n"}
	" font_extra_space" {insertObject "font_extra_space:= ;\n"}
	" font_identifier" {insertObject "font_identifier:= \"\";\n"}
	" font_normal_shrink" {insertObject "font_normal_shrink:= ;\n"}
	" font_normal_space" {insertObject "font_normal_space:= ;\n"}
	" font_normal_stretch" {insertObject "font_normal_stretch:= ;\n"}
	" font_quad" {insertObject "font_quad:= ;\n"}
	" font_size" {insertObject "font_size:= ;\n"}
	" font_slant" {insertObject "font_slant:= ;\n"}
	" font_x_height" {insertObject "font_x_height:= ;\n"}
	" fontdimen" {insertObject "fontdimen : , , , \n"}
	" headerbytes" {insertObject "headerbytes : , , , "}
	" ligtable" {insertObject "ligtable \"\" : \"\" =: oct\"\";\n"}
	" kern" {insertObject "kern \#"}
    }
}

proc Mf::displayingProc {menu item} {
    switch $item {	
	" currentwindow" {insertObject "currentwindow:= ;\n"}
	" displayinwindow" {insertObject "display  inwindow ;\n"}
	" openwindowfromtoat" {insertObject "openwindow  from (,) to (,) at (,);\n"}
	" screen_cols" {insertObject "screen_cols:= ;\n"}
	" screen_rows" {insertObject "screen_rows:= ;\n"}
	" screenrule" {insertObject "screenrule(,);\n"}
    }
}

proc Mf::outputProc {menu item} {
    switch $item {	
	" openit" {insertObject "openit;\n"}
	" shipit" {insertObject "shipit;\n"}
	" showit" {insertObject "showit;\n"}
	" labels" {insertObject "labels();\n"}
	" labelsrangethru" {insertObject "labels(range  thru );\n"}
	" penlabels" {insertObject "penlabels();\n"}
	" makelabel" {insertObject "makelabel(\"\",);\n"}
	" makegrid..." {Mf::mkgridProc}
	" proofoffset" {insertObject "proofoffset(,);\n"}
	" proofrule" {insertObject "proofrule(,);\n"}
	" proofrulethickness" {insertObject "proofrulethickness:=;\n"}
	" grayfont" {insertObject "grayfont \"\";\n"}
	" labelfont" {insertObject "labelfont \"\";\n"}
	" slantfont" {insertObject "slantfont \"\";\n"}
	" titlefont" {insertObject "titlefont \"\";\n"}
    }
}

proc Mf::debuggingProc {menu item} {
    set item [string trimleft $item]
    switch $item {	
	"errhelp" {insertObject "errhelp "}
	"errmessage" {insertObject "errmessage \"\";\n"}
	"message" {insertObject "message \"\";\n"}
	"show" {insertObject "show ;\n"}
	"showtoken" {insertObject "showtoken ;\n"}
	"showvariable" {insertObject "showvariable ;\n"}
	default {insertObject "$item;\n"}
    }
}

proc Mf::miscProc {menu item} {
    set item [string trimleft $item]
    switch $item {	
	"interact" {insertObject "interact;\n"}
	"capsule_def" {insertObject "capsule_def ;\n"}
	"special" {insertObject "special \"\";\n"}
	"numspecial" {insertObject "numspecial ;\n"}
	default {insertObject "$item "}
    }
}

proc Mf::varintProc {menu item} {
    set item [string trimleft $item]
    switch $item {	
	"day" -
	"month" -
	"year" -
	"time" {insertObject "$item;"}
	default {insertObject "$item= ;\n"}
    }
}
